<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.433057223 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="C1-Premium" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundC1PremiumCPU_CYCLES &gt; 0), min(($BackendBoundC1PremiumSTALL_SLOT_BACKEND / (10 * $BackendBoundC1PremiumCPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Busy Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundC1PremiumSTALL_BACKEND &gt; 0), min(($BackendBusyBoundC1PremiumSTALL_BACKEND_BUSY / $BackendBusyBoundC1PremiumSTALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Cache L1D Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundC1PremiumSTALL_BACKEND_L1D + $BackendCacheL1DBoundC1PremiumSTALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundC1PremiumSTALL_BACKEND_L1D / ($BackendCacheL1DBoundC1PremiumSTALL_BACKEND_L1D + $BackendCacheL1DBoundC1PremiumSTALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Cache L2D Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundC1PremiumSTALL_BACKEND_L1D + $BackendCacheL2DBoundC1PremiumSTALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundC1PremiumSTALL_BACKEND_MEM / ($BackendCacheL2DBoundC1PremiumSTALL_BACKEND_L1D + $BackendCacheL2DBoundC1PremiumSTALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Backpressure Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due to other reasons like the SME unit being power down(TBD)" expression="if(($BackendSMEBackpressureBoundC1PremiumSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMEBackpressureBoundC1PremiumSTALL_BACKEND_BUSY_CMEBOUND / $BackendSMEBackpressureBoundC1PremiumSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME Backpressure Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Arbitration Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend because an SME is busy. The instruction cannot be sent to SME because it is waiting for arbitration." expression="if(($BackendSMEArbitrationBoundC1PremiumSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMEArbitrationBoundC1PremiumSTALL_BACKEND_BUSY_CME_ARB / $BackendSMEArbitrationBoundC1PremiumSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME Arbitration Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Busy Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy" expression="if(($BackendSMEBusyBoundC1PremiumSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMEBusyBoundC1PremiumSTALL_BACKEND_BUSY_CME / $BackendSMEBusyBoundC1PremiumSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME Busy Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the SME unit of the backend due to dependency to the other units of CPU for execution" expression="if(($BackendSMECPUBoundC1PremiumSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMECPUBoundC1PremiumSTALL_BACKEND_BUSY_CME_CPUBOUND / $BackendSMECPUBoundC1PremiumSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundC1PremiumSTALL_BACKEND &gt; 0), min(($BackendCoreBoundC1PremiumSTALL_BACKEND_CPUBOUND / $BackendCoreBoundC1PremiumSTALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to the resource constraints to dispatch to the SME" expression="if(($BackendCoreSMEBoundC1PremiumSTALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreSMEBoundC1PremiumSTALL_BACKEND_BUSY_CME / $BackendCoreSMEBoundC1PremiumSTALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core Other Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as some other resource is unavailable" expression="if(($BackendCoreOtherBoundC1PremiumSTALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreOtherBoundC1PremiumIMP_STALL_BACKEND_CPUBOUND_OTHER / $BackendCoreOtherBoundC1PremiumSTALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Other Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core Rename Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundC1PremiumSTALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundC1PremiumSTALL_BACKEND_RENAME / $BackendCoreRenameBoundC1PremiumSTALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core Specuation Throttle Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the processor is stalling due to power throttling linked to low confidence branches" expression="if(($BackendCoreSpecuationThrottleBoundC1PremiumSTALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreSpecuationThrottleBoundC1PremiumIMP_STALL_BACKEND_SPEC_THROT / $BackendCoreSpecuationThrottleBoundC1PremiumSTALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Specuation Throttle Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundC1PremiumSTALL_BACKEND &gt; 0), min(($BackendMemoryBoundC1PremiumSTALL_BACKEND_MEMBOUND / $BackendMemoryBoundC1PremiumSTALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundC1PremiumSTALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundC1PremiumSTALL_BACKEND_L1D + $BackendMemoryCacheBoundC1PremiumSTALL_BACKEND_MEM) / $BackendMemoryCacheBoundC1PremiumSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME LSRT Barrier Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy because a CPU barrier waits for SME load/store transaction completion" expression="if(($BackendSMELSRTBarrierBoundC1PremiumSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMELSRTBarrierBoundC1PremiumSTALL_BACKEND_MEM_CME_BARRIER / $BackendSMELSRTBarrierBoundC1PremiumSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME LSRT Barrier Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend caused by load or store address hazards caused by SME unit memory execution dependency SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing memory execution units in them to have dependencies on data accesses" expression="if(($BackendMemorySMEBoundC1PremiumSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemorySMEBoundC1PremiumSTALL_BACKEND_MEM_CME / $BackendMemorySMEBoundC1PremiumSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Memory Hazard CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to a SME LSRT hazard causing SME instructions to stall. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both the execution units to have dependencies on data accesses." expression="if(($BackendSMEMemoryHazardCPUBoundC1PremiumSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMEMemoryHazardCPUBoundC1PremiumSTALL_BACKEND_MEM_CME_HZ_ON_CPU / $BackendSMEMemoryHazardCPUBoundC1PremiumSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME Memory Hazard CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME LSRT Full Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due to the LSRT being full. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both execution units to have dependencies on data accesses." expression="if(($BackendSMELSRTFullBoundC1PremiumSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMELSRTFullBoundC1PremiumSTALL_BACKEND_MEM_CME_LSRT_FULL / $BackendSMELSRTFullBoundC1PremiumSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME LSRT Full Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend CPU Memory Hazard SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due SME LSRT hazard causing CPU instructions to stall. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both execution units to have dependencies on data accesses." expression="if(($BackendCPUMemoryHazardSMEBoundC1PremiumSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendCPUMemoryHazardSMEBoundC1PremiumSTALL_BACKEND_MEM_CPU_HZ_ON_CME / $BackendCPUMemoryHazardSMEBoundC1PremiumSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend CPU Memory Hazard SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Store Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundC1PremiumSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundC1PremiumSTALL_BACKEND_ST / $BackendMemoryStoreBoundC1PremiumSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory TLB Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundC1PremiumSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundC1PremiumSTALL_BACKEND_TLB / $BackendMemoryTLBBoundC1PremiumSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesC1PremiumCPU_CYCLES &gt; 0), min(($BackendStalledCyclesC1PremiumSTALL_BACKEND / $BackendStalledCyclesC1PremiumCPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Bad Speculation">
        <series color="19,148,180" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationC1PremiumCPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationC1PremiumOP_SPEC &gt; 0), min((((1 - ($BadSpeculationC1PremiumSTALL_SLOT / (10 * $BadSpeculationC1PremiumCPU_CYCLES))) * (1 - ($BadSpeculationC1PremiumOP_RETIRED / $BadSpeculationC1PremiumOP_SPEC))) + ($BadSpeculationC1PremiumSTALL_FRONTEND_FLUSH / $BadSpeculationC1PremiumCPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(((($BarrierOperationsPercentageC1PremiumISB_SPEC + $BarrierOperationsPercentageC1PremiumDSB_SPEC) + $BarrierOperationsPercentageC1PremiumDMB_SPEC) / $BarrierOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Direct Percentage">
        <series color="19,148,180" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageC1PremiumBR_RETIRED &gt; 0), min(($BranchDirectPercentageC1PremiumBR_IMMED_RETIRED / $BranchDirectPercentageC1PremiumBR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Indirect Percentage">
        <series color="19,148,180" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageC1PremiumBR_RETIRED &gt; 0), min(($BranchIndirectPercentageC1PremiumBR_IND_RETIRED / $BranchIndirectPercentageC1PremiumBR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageC1PremiumBR_RETIRED &gt; 0), min(($BranchMispredictionPercentageC1PremiumBR_MIS_PRED_RETIRED / $BranchMispredictionPercentageC1PremiumBR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKIC1PremiumINST_RETIRED &gt; 0), (($BranchMPKIC1PremiumBR_MIS_PRED_RETIRED / $BranchMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($BranchOperationsPercentageC1PremiumPC_WRITE_SPEC / $BranchOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Execution Unit Utilization">
        <series color="19,148,180" description="This metric measures the average number of branch operations executed per cycle" expression="if(($BranchExecutionUnitUtilizationC1PremiumCPU_CYCLES &gt; 0), ($BranchExecutionUnitUtilizationC1PremiumIMP_OP_BRU_ISSUE / $BranchExecutionUnitUtilizationC1PremiumCPU_CYCLES), 0)" name="Branch Execution Unit Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Return Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageC1PremiumBR_RETIRED &gt; 0), min(($BranchReturnPercentageC1PremiumBR_RETURN_RETIRED / $BranchReturnPercentageC1PremiumBR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Bus Access Average Count">
        <series color="19,148,180" description="This metric measures the average count of bus accesses taken for read and write requests made by this processor" expression="if(($BusAccessAverageCountC1PremiumBUS_REQ &gt; 0), (($BusAccessAverageCountC1PremiumBUS_ACCESS_RD + $BusAccessAverageCountC1PremiumBUS_ACCESS_WR) / $BusAccessAverageCountC1PremiumBUS_REQ), 0)" name="Bus Access Average Count" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Bus Read Request Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of read requests made by this processor on the system bus in CPU cycles" expression="if(($BusReadRequestAverageLatencyC1PremiumBUS_REQ_RD &gt; 0), ($BusReadRequestAverageLatencyC1PremiumBUS_REQ_RD_PERCYC / $BusReadRequestAverageLatencyC1PremiumBUS_REQ_RD), 0)" name="Bus Read Request Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Far Percentage">
        <series color="19,148,180" description="This metric measures the ratio of compare and swap instructions that did not execute locally to the PE to the total compare and swap instructions" expression="if(($CompareAndSwapFarPercentageC1PremiumCAS_SPEC &gt; 0), min((1 - ($CompareAndSwapFarPercentageC1PremiumCAS_NEAR_SPEC / $CompareAndSwapFarPercentageC1PremiumCAS_SPEC)), 1), 0)" name="Compare and Swap Far Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Fail Percentage">
        <series color="19,148,180" description="This metric measures the ratio of failed compare and swap instructions speculatively executed locally to the PE that do not update the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearFailPercentageC1PremiumCAS_NEAR_SPEC &gt; 0), min((1 - ($CompareAndSwapNearFailPercentageC1PremiumCAS_NEAR_PASS / $CompareAndSwapNearFailPercentageC1PremiumCAS_NEAR_SPEC)), 1), 0)" name="Compare and Swap Near Fail Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Pass Percentage">
        <series color="19,148,180" description="This metric measures the ratio of passed compare and swap instructions speculatively executed locally to the PE that updated the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearPassPercentageC1PremiumCAS_NEAR_SPEC &gt; 0), min(($CompareAndSwapNearPassPercentageC1PremiumCAS_NEAR_PASS / $CompareAndSwapNearPassPercentageC1PremiumCAS_NEAR_SPEC), 1), 0)" name="Compare and Swap Near Pass Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Percentage">
        <series color="19,148,180" description="This metric measures the ratio of compare and swap instructions speculatively executed locally to the PE to the total compare and swap instructions" expression="if(($CompareAndSwapNearPercentageC1PremiumCAS_SPEC &gt; 0), min(($CompareAndSwapNearPercentageC1PremiumCAS_NEAR_SPEC / $CompareAndSwapNearPercentageC1PremiumCAS_SPEC), 1), 0)" name="Compare and Swap Near Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Allocation Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles where the CPU had an SME allocated to it, such that the SME and Streaming SVE state of the CPU is held in that SME to the total number of CPU cycles" expression="if(($SMEAllocationCyclesPercentageC1PremiumCPU_CYCLES &gt; 0), min(($SMEAllocationCyclesPercentageC1PremiumCYCLES_CME_ALLOC / $SMEAllocationCyclesPercentageC1PremiumCPU_CYCLES), 1), 0)" name="SME Allocation Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME Arithmetic EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the ALU execution unit per cycle" expression="if(($SMEArithmeticEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($SMEArithmeticEUUtilizationC1PremiumCME_OP_ALU_ISSUE / $SMEArithmeticEUUtilizationC1PremiumCME_CYCLES), 0)" name="SME Arithmetic EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Arbitration Pending Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles where the CPU is in arbitration while attempting to access an SME to the total number of CPU cycles" expression="if(($SMEArbitrationPendingCyclesPercentageC1PremiumCPU_CYCLES &gt; 0), min(($SMEArbitrationPendingCyclesPercentageC1PremiumCYCLES_ARB_PENDING_CME / $SMEArbitrationPendingCyclesPercentageC1PremiumCPU_CYCLES), 1), 0)" name="SME Arbitration Pending Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of SME" expression="if(($SMEBackendBoundC1PremiumCME_CYCLES &gt; 0), min(($SMEBackendBoundC1PremiumCME_STALL_BACKEND / $SMEBackendBoundC1PremiumCME_CYCLES), 1), 0)" name="SME Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to DP issue queues not accepting instructions" expression="if(($SMEBackendCoreBoundC1PremiumCME_STALL_BACKEND &gt; 0), min(($SMEBackendCoreBoundC1PremiumCME_STALL_BACKEND_CORE / $SMEBackendCoreBoundC1PremiumCME_STALL_BACKEND), 1), 0)" name="SME Backend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not accepting instructions" expression="if(($SMEBackendMemoryBoundC1PremiumCME_STALL_BACKEND &gt; 0), min(($SMEBackendMemoryBoundC1PremiumCME_STALL_BACKEND_MEM / $SMEBackendMemoryBoundC1PremiumCME_STALL_BACKEND), 1), 0)" name="SME Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend for memory resource constraints, with the oldest instruction in at least one of the LS issue queues waiting for cache arbitration" expression="if(($SMEBackendCacheBoundC1PremiumCME_STALL_BACKEND_MEM &gt; 0), min(($SMEBackendCacheBoundC1PremiumCME_STALL_BACKEND_MEM_CACHE / $SMEBackendCacheBoundC1PremiumCME_STALL_BACKEND_MEM), 1), 0)" name="SME Backend Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Store Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not accepting instructions" expression="if(($SMEBackendStoreBoundC1PremiumCME_STALL_BACKEND_MEM &gt; 0), min(($SMEBackendStoreBoundC1PremiumCME_STALL_BACKEND_MEM_STORE / $SMEBackendStoreBoundC1PremiumCME_STALL_BACKEND_MEM), 1), 0)" name="SME Backend Store Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Prefetch Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to hardware prefetcher issue queues not accepting instructions" expression="if(($SMEBackendPrefetchBoundC1PremiumCME_STALL_BACKEND &gt; 0), min(($SMEBackendPrefetchBoundC1PremiumCME_STALL_BACKEND_PF / $SMEBackendPrefetchBoundC1PremiumCME_STALL_BACKEND), 1), 0)" name="SME Backend Prefetch Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME Bus Access Average Length">
        <series color="19,148,180" description="This metric measures the average length of bus accesses taken for all the bus requests made by SME" expression="if(($SMEBusAccessAverageLengthC1PremiumCME_BUS_REQ &gt; 0), ($SMEBusAccessAverageLengthC1PremiumCME_BUS_ACCESS / $SMEBusAccessAverageLengthC1PremiumCME_BUS_REQ), 0)" name="SME Bus Access Average Length" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend Bound">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of SME" expression="if(($SMEFrontendBoundC1PremiumCME_CYCLES &gt; 0), min(($SMEFrontendBoundC1PremiumCME_STALL_FRONTEND / $SMEFrontendBoundC1PremiumCME_CYCLES), 1), 0)" name="SME Frontend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by no instructions sent by CPU" expression="if(($SMEFrontendCPUBoundC1PremiumCME_STALL_FRONTEND &gt; 0), min(($SMEFrontendCPUBoundC1PremiumCME_STALL_FRONTEND_CPU / $SMEFrontendCPUBoundC1PremiumCME_STALL_FRONTEND), 1), 0)" name="SME Frontend CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend Other CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by no instructions sent by CPU" expression="if(($SMEFrontendOtherCPUBoundC1PremiumCME_STALL_FRONTEND &gt; 0), min(($SMEFrontendOtherCPUBoundC1PremiumCME_STALL_FRONTEND_OTHER_CPU / $SMEFrontendOtherCPUBoundC1PremiumCME_STALL_FRONTEND), 1), 0)" name="SME Frontend Other CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME IPC">
        <series color="19,148,180" description="This metric measures the number of SME instructions retired per SME cycles" expression="if(($SMEIPCC1PremiumCME_CYCLES &gt; 0), (($SMEIPCC1PremiumCME_INST_RETIRED / $SMEIPCC1PremiumCME_CYCLES) * 100), 0)" name="SME IPC" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ DP0 Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue DP0, but it is full" expression="if(($IQDP0StallPercentageC1PremiumCME_STALL_BACKEND &gt; 0), min(($IQDP0StallPercentageC1PremiumCME_DISPATCH_STALL_IQ_DP0 / $IQDP0StallPercentageC1PremiumCME_STALL_BACKEND), 1), 0)" name="IQ DP0 Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ DP1 Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue DP1, but it is full" expression="if(($IQDP1StallPercentageC1PremiumCME_STALL_BACKEND &gt; 0), min(($IQDP1StallPercentageC1PremiumCME_DISPATCH_STALL_IQ_DP1 / $IQDP1StallPercentageC1PremiumCME_STALL_BACKEND), 1), 0)" name="IQ DP1 Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ Load Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue LD, but it is full" expression="if(($IQLoadStallPercentageC1PremiumCME_STALL_BACKEND &gt; 0), min(($IQLoadStallPercentageC1PremiumCME_DISPATCH_STALL_IQ_LD / $IQLoadStallPercentageC1PremiumCME_STALL_BACKEND), 1), 0)" name="IQ Load Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Accuracy">
        <series color="19,148,180" description="This metric measures SME L1D cache prefetcher accuracy" expression="if(($SMEL1DCachePrefetcherAccuracyC1PremiumCME_L1D_CACHE_REFILL_HWPRF &gt; 0), (($SMEL1DCachePrefetcherAccuracyC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherAccuracyC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF) / $SMEL1DCachePrefetcherAccuracyC1PremiumCME_L1D_CACHE_REFILL_HWPRF), 0)" name="SME L1D Cache Prefetcher Accuracy" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Coverage">
        <series color="19,148,180" description="This metric measures L1D cache prefetcher coverage" expression="if((((($SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF) + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_REFILL_RD) + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_REFILL_WR) &gt; 0), (($SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF) / ((($SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF) + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_REFILL_RD) + $SMEL1DCachePrefetcherCoverageC1PremiumCME_L1D_CACHE_REFILL_WR)), 0)" name="SME L1D Cache Prefetcher Coverage" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Timeliness">
        <series color="19,148,180" description="This metric measures SME L1D cache prefetcher timeliness" expression="if((($SMEL1DCachePrefetcherTimelinessC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherTimelinessC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF) &gt; 0), ($SMEL1DCachePrefetcherTimelinessC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF / ($SMEL1DCachePrefetcherTimelinessC1PremiumCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherTimelinessC1PremiumCME_L1D_LFB_HIT_RW_FHWPRF)), 0)" name="SME L1D Cache Prefetcher Timeliness" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L1D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache access hits to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($SMEL1DCacheHitPercentageC1PremiumCME_L1D_CACHE &gt; 0), min(($SMEL1DCacheHitPercentageC1PremiumCME_L1D_CACHE_HIT / $SMEL1DCacheHitPercentageC1PremiumCME_L1D_CACHE), 1), 0)" name="SME L1D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($SMEL1DCacheMissPercentageC1PremiumCME_L1D_CACHE &gt; 0), min(($SMEL1DCacheMissPercentageC1PremiumCME_L1D_CACHE_REFILL / $SMEL1DCacheMissPercentageC1PremiumCME_L1D_CACHE), 1), 0)" name="SME L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of SME level 1 data cache accesses missed per thousand SME instructions executed" expression="if(($SMEL1DCacheMPKIC1PremiumCME_INST_RETIRED &gt; 0), (($SMEL1DCacheMPKIC1PremiumCME_L1D_CACHE_REFILL / $SMEL1DCacheMPKIC1PremiumCME_INST_RETIRED) * 1000), 0)" name="SME L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L3D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 3 cache access hits to the total number of level 3 cache accesses, requested by the SME" expression="if(($SMEL3DCacheHitPercentageC1PremiumCME_L3D_CACHE &gt; 0), min(($SMEL3DCacheHitPercentageC1PremiumCME_L3D_CACHE_HIT / $SMEL3DCacheHitPercentageC1PremiumCME_L3D_CACHE), 1), 0)" name="SME L3D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L3D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 3 cache accesses missed to the total number of level 3 cache accesses, requested by the SME" expression="if(($SMEL3DCacheMissPercentageC1PremiumCME_L3D_CACHE &gt; 0), min(($SMEL3DCacheMissPercentageC1PremiumCME_L3D_CACHE_REFILL / $SMEL3DCacheMissPercentageC1PremiumCME_L3D_CACHE), 1), 0)" name="SME L3D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L3D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of SME level 3 cache accesses missed per thousand SME instructions executed" expression="if(($SMEL3DCacheMPKIC1PremiumCME_INST_RETIRED &gt; 0), (($SMEL3DCacheMPKIC1PremiumCME_L3D_CACHE_REFILL / $SMEL3DCacheMPKIC1PremiumCME_INST_RETIRED) * 1000), 0)" name="SME L3D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME last level cache read accesses hit in the cache to the total number of SME last level cache accesses" expression="if(($SMELLCacheReadHitPercentageC1PremiumCME_LL_CACHE_RD &gt; 0), min((($SMELLCacheReadHitPercentageC1PremiumCME_LL_CACHE_RD - $SMELLCacheReadHitPercentageC1PremiumCME_LL_CACHE_MISS_RD) / $SMELLCacheReadHitPercentageC1PremiumCME_LL_CACHE_RD), 1), 0)" name="SME LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME last level cache read accesses missed to the total number of last level cache accesses requested by the SME" expression="if(($SMELLCacheReadMissPercentageC1PremiumCME_LL_CACHE_RD &gt; 0), min(($SMELLCacheReadMissPercentageC1PremiumCME_LL_CACHE_MISS_RD / $SMELLCacheReadMissPercentageC1PremiumCME_LL_CACHE_RD), 1), 0)" name="SME LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of SME last level cache read accesses missed per SME thousand instructions executed" expression="if(($SMELLCacheReadMPKIC1PremiumCME_INST_RETIRED &gt; 0), (($SMELLCacheReadMPKIC1PremiumCME_LL_CACHE_MISS_RD / $SMELLCacheReadMPKIC1PremiumCME_INST_RETIRED) * 1000), 0)" name="SME LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Load Operations Percentage">
        <series color="19,148,180" description="This metric measures SME load operations as a percentage of SME operations speculatively executed" expression="if(($SMELoadOperationsPercentageC1PremiumCME_INST_RETIRED &gt; 0), min(($SMELoadOperationsPercentageC1PremiumCME_LD_SPEC / $SMELoadOperationsPercentageC1PremiumCME_INST_RETIRED), 1), 0)" name="SME Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME MAC EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the MAC execution unit per cycle" expression="if(($SMEMACEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($SMEMACEUUtilizationC1PremiumCME_OP_MAC_ISSUE / $SMEMACEUUtilizationC1PremiumCME_CYCLES), 0)" name="SME MAC EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Matmul Datapath EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the Matmul data path execution unit per cycle" expression="if(($MatmulDatapathEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($MatmulDatapathEUUtilizationC1PremiumCME_OP_MMDP_ISSUE / $MatmulDatapathEUUtilizationC1PremiumCME_CYCLES), 0)" name="Matmul Datapath EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Matmul Move EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the Matmul move execution unit per cycle" expression="if(($MatmulMoveEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($MatmulMoveEUUtilizationC1PremiumCME_OP_MMMV_ISSUE / $MatmulMoveEUUtilizationC1PremiumCME_CYCLES), 0)" name="Matmul Move EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Permute EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the permute execution unit per cycle" expression="if(($PermuteEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($PermuteEUUtilizationC1PremiumCME_OP_PERM_ISSUE / $PermuteEUUtilizationC1PremiumCME_CYCLES), 0)" name="Permute EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Retiring">
        <series color="19,148,180" description="This metric is the percentage of cycles that were not stalled for any reason" expression="if(($SMERetiringC1PremiumCME_CYCLES &gt; 0), min(((($SMERetiringC1PremiumCME_CYCLES - $SMERetiringC1PremiumCME_STALL_FRONTEND) - $SMERetiringC1PremiumCME_STALL_BACKEND) / $SMERetiringC1PremiumCME_CYCLES), 1), 0)" name="SME Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the store execution unit per cycle" expression="if(($StoreEUUtilizationC1PremiumCME_CYCLES &gt; 0), ($StoreEUUtilizationC1PremiumCME_OP_ST_ISSUE / $StoreEUUtilizationC1PremiumCME_CYCLES), 0)" name="Store EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($SMEStoreOperationsPercentageC1PremiumCME_INST_RETIRED &gt; 0), min(($SMEStoreOperationsPercentageC1PremiumCME_ST_SPEC / $SMEStoreOperationsPercentageC1PremiumCME_INST_RETIRED), 1), 0)" name="SME Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System DRAM Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of DRAM hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from the local DRAM." expression="if(($SMESystemDRAMHitPercentageC1PremiumCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemDRAMHitPercentageC1PremiumCME_DRAM_ACCESS / $SMESystemDRAMHitPercentageC1PremiumCME_L1D_CACHE_REFILL), 1), 0)" name="SME System DRAM Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System L3D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of L3 cache hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from L3 cache." expression="if(($SMESystemL3DCacheHitPercentageC1PremiumCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemL3DCacheHitPercentageC1PremiumCME_L3D_CACHE_HIT / $SMESystemL3DCacheHitPercentageC1PremiumCME_L1D_CACHE_REFILL), 1), 0)" name="SME System L3D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System Last Level Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of Last level cache hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from LL cache." expression="if(($SMESystemLastLevelCacheHitPercentageC1PremiumCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemLastLevelCacheHitPercentageC1PremiumCME_LL_CACHE_HIT / $SMESystemLastLevelCacheHitPercentageC1PremiumCME_L1D_CACHE_REFILL), 1), 0)" name="SME System Last Level Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionC1PremiumINST_RETIRED &gt; 0), ($CyclesPerInstructionC1PremiumCPU_CYCLES / $CyclesPerInstructionC1PremiumINST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($CryptoOperationsPercentageC1PremiumCRYPTO_SPEC / $CryptoOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKIC1PremiumINST_RETIRED &gt; 0), (($DTLBMPKIC1PremiumDTLB_WALK / $DTLBMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB Walk Average Depth of Accesses">
        <series color="19,148,180" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesC1PremiumDTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesC1PremiumDTLB_STEP / $DTLBWalkAverageDepthOfAccessesC1PremiumDTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB Walk Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyC1PremiumDTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyC1PremiumDTLB_WALK_PERCYC / $DTLBWalkAverageLatencyC1PremiumDTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Block Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned a block to the total number of data TLB accesses. Block size is any memory block larger than the page granule size set by the system." expression="if(($DTLBWalkBlockPercentageC1PremiumL1D_TLB &gt; 0), min(($DTLBWalkBlockPercentageC1PremiumDTLB_WALK_BLOCK / $DTLBWalkBlockPercentageC1PremiumL1D_TLB), 1), 0)" name="DTLB Walk Block Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Large Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageC1PremiumL1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageC1PremiumDTLB_WALK_LARGE / $DTLBWalkLargePagePercentageC1PremiumL1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned a page to the total number of data TLB accesses. Page size is determined by the page granule size set by the system." expression="if(($DTLBWalkPagePercentageC1PremiumL1D_TLB &gt; 0), min(($DTLBWalkPagePercentageC1PremiumDTLB_WALK_PAGE / $DTLBWalkPagePercentageC1PremiumL1D_TLB), 1), 0)" name="DTLB Walk Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageC1PremiumL1D_TLB &gt; 0), min(($DTLBWalkPercentageC1PremiumDTLB_WALK / $DTLBWalkPercentageC1PremiumL1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Small Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageC1PremiumL1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageC1PremiumDTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageC1PremiumL1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Half Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageC1PremiumINST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageC1PremiumFP_HP_SPEC / $HalfPrecisionFloatingPointPercentageC1PremiumINST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Single Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageC1PremiumINST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageC1PremiumFP_SP_SPEC / $SinglePrecisionFloatingPointPercentageC1PremiumINST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Double Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageC1PremiumINST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageC1PremiumFP_DP_SPEC / $DoublePrecisionFloatingPointPercentageC1PremiumINST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by any instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($FloatingPointOperationsPerCycleC1PremiumCPU_CYCLES &gt; 0), (($FloatingPointOperationsPerCycleC1PremiumFP_SCALE_OPS_SPEC + $FloatingPointOperationsPerCycleC1PremiumFP_FIXED_OPS_SPEC) / $FloatingPointOperationsPerCycleC1PremiumCPU_CYCLES), 0)" name="Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundC1PremiumCPU_CYCLES &gt; 0), min((($FrontendBoundC1PremiumSTALL_SLOT_FRONTEND / (10 * $FrontendBoundC1PremiumCPU_CYCLES)) - ($FrontendBoundC1PremiumSTALL_FRONTEND_FLUSH / $FrontendBoundC1PremiumCPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Cache L1I Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundC1PremiumSTALL_FRONTEND_L1I + $FrontendCacheL1IBoundC1PremiumSTALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundC1PremiumSTALL_FRONTEND_L1I / ($FrontendCacheL1IBoundC1PremiumSTALL_FRONTEND_L1I + $FrontendCacheL1IBoundC1PremiumSTALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Cache L2I Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundC1PremiumSTALL_FRONTEND_L1I + $FrontendCacheL2IBoundC1PremiumSTALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundC1PremiumSTALL_FRONTEND_MEM / ($FrontendCacheL2IBoundC1PremiumSTALL_FRONTEND_L1I + $FrontendCacheL2IBoundC1PremiumSTALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundC1PremiumSTALL_FRONTEND &gt; 0), min(($FrontendCoreBoundC1PremiumSTALL_FRONTEND_CPUBOUND / $FrontendCoreBoundC1PremiumSTALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flow Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundC1PremiumSTALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundC1PremiumSTALL_FRONTEND_FLOW / $FrontendCoreFlowBoundC1PremiumSTALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flush Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundC1PremiumSTALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundC1PremiumSTALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundC1PremiumSTALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flush Machine Clear Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by machine resteers other than bad speculation" expression="if(($FrontendCoreFlushMachineClearBoundC1PremiumSTALL_FRONTEND_FLUSH &gt; 0), min(($FrontendCoreFlushMachineClearBoundC1PremiumIMP_STALL_FRONTEND_FLUSH_CLEAR / $FrontendCoreFlushMachineClearBoundC1PremiumSTALL_FRONTEND_FLUSH), 1), 0)" name="Frontend Core Flush Machine Clear Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flush Branch Resteer Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation" expression="if(($FrontendCoreFlushBranchResteerBoundC1PremiumSTALL_FRONTEND_FLUSH &gt; 0), min(($FrontendCoreFlushBranchResteerBoundC1PremiumIMP_STALL_FRONTEND_FLUSH_RESTEER / $FrontendCoreFlushBranchResteerBoundC1PremiumSTALL_FRONTEND_FLUSH), 1), 0)" name="Frontend Core Flush Branch Resteer Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Specuation Throttle Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the processor is stalling due to power throttling linked to low confidence branches" expression="if(($FrontendCoreSpecuationThrottleBoundC1PremiumSTALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreSpecuationThrottleBoundC1PremiumIMP_STALL_FRONTEND_SPEC_THROT / $FrontendCoreSpecuationThrottleBoundC1PremiumSTALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Specuation Throttle Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundC1PremiumSTALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundC1PremiumSTALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundC1PremiumSTALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Mem Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundC1PremiumSTALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundC1PremiumSTALL_FRONTEND_L1I + $FrontendMemCacheBoundC1PremiumSTALL_FRONTEND_MEM) / $FrontendMemCacheBoundC1PremiumSTALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Mem TLB Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundC1PremiumSTALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundC1PremiumSTALL_FRONTEND_TLB / $FrontendMemTLBBoundC1PremiumSTALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesC1PremiumCPU_CYCLES &gt; 0), min(($FrontendStalledCyclesC1PremiumSTALL_FRONTEND / $FrontendStalledCyclesC1PremiumCPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction Fetch Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of instruction fetches in CPU cycles" expression="if(($InstructionFetchAverageLatencyC1PremiumINST_FETCH &gt; 0), ($InstructionFetchAverageLatencyC1PremiumINST_FETCH_PERCYC / $InstructionFetchAverageLatencyC1PremiumINST_FETCH), 0)" name="Instruction Fetch Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Integer Execution Unit Utilization">
        <series color="19,148,180" description="This metric measures the average number of integer operations executed per cycle" expression="if(($IntegerExecutionUnitUtilizationC1PremiumCPU_CYCLES &gt; 0), ($IntegerExecutionUnitUtilizationC1PremiumIMP_OP_DPU_ISSUE / $IntegerExecutionUnitUtilizationC1PremiumCPU_CYCLES), 0)" name="Integer Execution Unit Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageC1PremiumINST_SPEC &gt; 0), min((($IntegerOperationsPercentageC1PremiumDP_SPEC - $IntegerOperationsPercentageC1PremiumDSB_SPEC) / $IntegerOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleC1PremiumCPU_CYCLES &gt; 0), ($InstructionsPerCycleC1PremiumINST_RETIRED / $InstructionsPerCycleC1PremiumCPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store IQ Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where the oldest operation was a load or store operation" expression="if(($LoadStoreIQStallPercentageC1PremiumSTALL_BACKEND_BUSY &gt; 0), min(($LoadStoreIQStallPercentageC1PremiumIMP_STALL_BACKEND_IQ_LS / $LoadStoreIQStallPercentageC1PremiumSTALL_BACKEND_BUSY), 1), 0)" name="Load/Store IQ Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer MX IQ Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where the oldest operation was an integer operation" expression="if(($IntegerMXIQStallPercentageC1PremiumSTALL_BACKEND_BUSY &gt; 0), min(($IntegerMXIQStallPercentageC1PremiumIMP_STALL_BACKEND_IQ_MX / $IntegerMXIQStallPercentageC1PremiumSTALL_BACKEND_BUSY), 1), 0)" name="Integer MX IQ Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer SX IQ Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where the oldest operation was an integer operation" expression="if(($IntegerSXIQStallPercentageC1PremiumSTALL_BACKEND_BUSY &gt; 0), min(($IntegerSXIQStallPercentageC1PremiumIMP_STALL_BACKEND_IQ_SX / $IntegerSXIQStallPercentageC1PremiumSTALL_BACKEND_BUSY), 1), 0)" name="Integer SX IQ Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Vector IQ Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where the oldest operation was a vector operation" expression="if(($VectorIQStallPercentageC1PremiumSTALL_BACKEND_BUSY &gt; 0), min(($VectorIQStallPercentageC1PremiumIMP_STALL_BACKEND_IQ_VX / $VectorIQStallPercentageC1PremiumSTALL_BACKEND_BUSY), 1), 0)" name="Vector IQ Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKIC1PremiumINST_RETIRED &gt; 0), (($ITLBMPKIC1PremiumITLB_WALK / $ITLBMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB Walk Average Depth of Accesses">
        <series color="19,148,180" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesC1PremiumITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesC1PremiumITLB_STEP / $ITLBWalkAverageDepthOfAccessesC1PremiumITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB Walk Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyC1PremiumITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyC1PremiumITLB_WALK_PERCYC / $ITLBWalkAverageLatencyC1PremiumITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Block Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned a block to the total number of instruction TLB accesses. Block size is any memory block larger than the page granule size set by the system." expression="if(($ITLBWalkBlockPercentageC1PremiumL1I_TLB &gt; 0), min(($ITLBWalkBlockPercentageC1PremiumITLB_WALK_BLOCK / $ITLBWalkBlockPercentageC1PremiumL1I_TLB), 1), 0)" name="ITLB Walk Block Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Large Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageC1PremiumL1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageC1PremiumITLB_WALK_LARGE / $ITLBWalkLargePagePercentageC1PremiumL1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned a page to the total number of instruction TLB accesses. Page size is determined by the page granule size set by the system." expression="if(($ITLBWalkPagePercentageC1PremiumL1I_TLB &gt; 0), min(($ITLBWalkPagePercentageC1PremiumITLB_WALK_PAGE / $ITLBWalkPagePercentageC1PremiumL1I_TLB), 1), 0)" name="ITLB Walk Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageC1PremiumL1I_TLB &gt; 0), min(($ITLBWalkPercentageC1PremiumITLB_WALK / $ITLBWalkPercentageC1PremiumL1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Small Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageC1PremiumL1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageC1PremiumITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageC1PremiumL1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Prefetcher Accuracy">
        <series color="19,148,180" description="This metric measures L1D cache prefetcher accuracy" expression="if((($L1DPrefetcherAccuracyC1PremiumL1D_CACHE_REFILL_HWPRF + $L1DPrefetcherAccuracyC1PremiumL1D_LFB_HIT_RW_FHWPRF) &gt; 0), (($L1DPrefetcherAccuracyC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherAccuracyC1PremiumL1D_LFB_HIT_RW_FHWPRF) / ($L1DPrefetcherAccuracyC1PremiumL1D_CACHE_REFILL_HWPRF + $L1DPrefetcherAccuracyC1PremiumL1D_LFB_HIT_RW_FHWPRF)), 0)" name="L1D Prefetcher Accuracy" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Prefetcher Coverage">
        <series color="19,148,180" description="This metric measures L1D cache prefetcher coverage" expression="if((((($L1DPrefetcherCoverageC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherCoverageC1PremiumL1D_LFB_HIT_RW_FHWPRF) + $L1DPrefetcherCoverageC1PremiumL1D_CACHE_REFILL_RD) + $L1DPrefetcherCoverageC1PremiumL1D_CACHE_REFILL_WR) &gt; 0), (($L1DPrefetcherCoverageC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherCoverageC1PremiumL1D_LFB_HIT_RW_FHWPRF) / ((($L1DPrefetcherCoverageC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherCoverageC1PremiumL1D_LFB_HIT_RW_FHWPRF) + $L1DPrefetcherCoverageC1PremiumL1D_CACHE_REFILL_RD) + $L1DPrefetcherCoverageC1PremiumL1D_CACHE_REFILL_WR)), 0)" name="L1D Prefetcher Coverage" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Prefetcher Timeliness">
        <series color="19,148,180" description="This metric measures L1D cache prefetcher timeliness" expression="if((($L1DPrefetcherTimelinessC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherTimelinessC1PremiumL1D_LFB_HIT_RW_FHWPRF) &gt; 0), ($L1DPrefetcherTimelinessC1PremiumL1D_CACHE_HIT_RW_FHWPRF / ($L1DPrefetcherTimelinessC1PremiumL1D_CACHE_HIT_RW_FHWPRF + $L1DPrefetcherTimelinessC1PremiumL1D_LFB_HIT_RW_FHWPRF)), 0)" name="L1D Prefetcher Timeliness" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKIC1PremiumINST_RETIRED &gt; 0), ((($L1DCacheDemandMPKIC1PremiumL1D_CACHE_REFILL_RD + $L1DCacheDemandMPKIC1PremiumL1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageC1PremiumL1D_CACHE &gt; 0), min(($L1DCacheMissPercentageC1PremiumL1D_CACHE_REFILL / $L1DCacheMissPercentageC1PremiumL1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L1DCacheMPKIC1PremiumL1D_CACHE_REFILL / $L1DCacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageC1PremiumL1D_TLB &gt; 0), min(($L1DataTLBMissPercentageC1PremiumL1D_TLB_REFILL / $L1DataTLBMissPercentageC1PremiumL1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKIC1PremiumINST_RETIRED &gt; 0), (($L1DataTLBMPKIC1PremiumL1D_TLB_REFILL / $L1DataTLBMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageC1PremiumL1I_CACHE &gt; 0), min(($L1ICacheMissPercentageC1PremiumL1I_CACHE_REFILL / $L1ICacheMissPercentageC1PremiumL1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L1ICacheMPKIC1PremiumL1I_CACHE_REFILL / $L1ICacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageC1PremiumL1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageC1PremiumL1I_TLB_REFILL / $L1InstructionTLBMissPercentageC1PremiumL1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKIC1PremiumINST_RETIRED &gt; 0), (($L1InstructionTLBMPKIC1PremiumL1I_TLB_REFILL / $L1InstructionTLBMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageC1PremiumL2D_CACHE &gt; 0), min(($L2CacheMissPercentageC1PremiumL2D_CACHE_REFILL / $L2CacheMissPercentageC1PremiumL2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L2CacheMPKIC1PremiumL2D_CACHE_REFILL / $L2CacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher accuracy excluding L1 hardware prefetch requests" expression="if((($L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF + $L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL_HWPRF) &gt; 0), (($L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF) / ($L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF + $L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL_HWPRF)), 0)" name="L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Accuracy (L1 HW prefetch inclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher accuracy treating L1 hardware prefetches as demand requests" expression="if((($L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE + $L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL_HWPRF) &gt; 0), (($L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE) / ($L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE + $L2CachePrefetcherAccuracyL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL_HWPRF)), 0)" name="L2 Cache Prefetcher Accuracy (L1 HW prefetch inclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher coverage excluding L1 hardware prefetch requests" expression="if(((((($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL) - $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL_HWPRF) - $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumIMP_L2D_CACHE_REFILL_L1HWPRF) &gt; 0), (($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF) / (((($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL) - $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumL2D_CACHE_REFILL_HWPRF) - $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1PremiumIMP_L2D_CACHE_REFILL_L1HWPRF)), 0)" name="L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Coverage (L1 HW prefetch inclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher coverage treating L1 hardware prefetches as demand requests" expression="if((((($L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE) + $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL) - $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL_HWPRF) &gt; 0), (($L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE) / ((($L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE) + $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL) - $L2CachePrefetcherCoverageL1HWPrefetchInclusiveC1PremiumL2D_CACHE_REFILL_HWPRF)), 0)" name="L2 Cache Prefetcher Coverage (L1 HW prefetch inclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Timeliness (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher timeliness excluding L1 hardware prefetch requests" expression="if((($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF) &gt; 0), ($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF / ($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1PremiumL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1PremiumL2D_LFB_HIT_RW_FHWPRF)), 0)" name="L2 Cache Prefetcher Timeliness (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Timeliness (L1 HW prefetch inclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher timeliness treating L1 hardware prefetches as demand requests" expression="if((($L2CachePrefetcherTimelinessL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherTimelinessL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE) &gt; 0), ($L2CachePrefetcherTimelinessL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF / ($L2CachePrefetcherTimelinessL1HWPrefetchInclusiveC1PremiumIMP_L2_CACHE_HIT_LINE_PF + $L2CachePrefetcherTimelinessL1HWPrefetchInclusiveC1PremiumIMP_L2_PREFETCH_LATE)), 0)" name="L2 Cache Prefetcher Timeliness (L1 HW prefetch inclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageC1PremiumL2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageC1PremiumL2D_TLB_REFILL / $L2UnifiedTLBMissPercentageC1PremiumL2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKIC1PremiumINST_RETIRED &gt; 0), (($L2UnifiedTLBMPKIC1PremiumL2D_TLB_REFILL / $L2UnifiedTLBMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKIC1PremiumINST_RETIRED &gt; 0), ((($L2DCacheDemandMPKIC1PremiumL2D_CACHE_REFILL_RD + $L2DCacheDemandMPKIC1PremiumL2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageC1PremiumL2D_CACHE &gt; 0), min(($L2DCacheMissPercentageC1PremiumL2D_CACHE_REFILL / $L2DCacheMissPercentageC1PremiumL2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L2DCacheMPKIC1PremiumL2D_CACHE_REFILL / $L2DCacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level 2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMissPercentageC1PremiumL2I_CACHE &gt; 0), min(($L2ICacheMissPercentageC1PremiumL2I_CACHE_REFILL / $L2ICacheMissPercentageC1PremiumL2I_CACHE), 1), 0)" name="L2I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache instruction accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L2ICacheMPKIC1PremiumL2I_CACHE_REFILL / $L2ICacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L2I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageC1PremiumL3D_CACHE &gt; 0), min(($L3CacheMissPercentageC1PremiumL3D_CACHE_REFILL / $L3CacheMissPercentageC1PremiumL3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKIC1PremiumINST_RETIRED &gt; 0), (($L3CacheMPKIC1PremiumL3D_CACHE_REFILL / $L3CacheMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageC1PremiumINST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageC1PremiumLDREX_SPEC / $LoadExclusiveInstructionsPercentageC1PremiumINST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageC1PremiumLL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageC1PremiumLL_CACHE_RD - $LLCacheReadHitPercentageC1PremiumLL_CACHE_MISS_RD) / $LLCacheReadHitPercentageC1PremiumLL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageC1PremiumLL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageC1PremiumLL_CACHE_MISS_RD / $LLCacheReadMissPercentageC1PremiumLL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKIC1PremiumINST_RETIRED &gt; 0), (($LLCacheReadMPKIC1PremiumLL_CACHE_MISS_RD / $LLCacheReadMPKIC1PremiumINST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Load Operation Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of load operations in CPU cycles" expression="if(($LoadOperationAverageLatencyC1PremiumMEM_ACCESS &gt; 0), ($LoadOperationAverageLatencyC1PremiumMEM_ACCESS_RD_PERCYC / $LoadOperationAverageLatencyC1PremiumMEM_ACCESS), 0)" name="Load Operation Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageC1PremiumLDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageC1PremiumLD_SPEC / $LoadAsLoadStoreOperationsPercentageC1PremiumLDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($LoadOperationsPercentageC1PremiumLD_SPEC / $LoadOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageC1PremiumLDST_SPEC / $LoadStoreOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Atomics Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE atomics instructions speculatively executed locally to the PE to the total load and store instructions" expression="if(($LSEAtomicsPercentageC1PremiumLDST_SPEC &gt; 0), min(($LSEAtomicsPercentageC1PremiumLSE_LDST_SPEC / $LSEAtomicsPercentageC1PremiumLDST_SPEC), 1), 0)" name="LSE Atomics Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Load Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE load instructions speculatively executed to the total LSE instructions" expression="if(($LSELoadPercentageC1PremiumLSE_LDST_SPEC &gt; 0), min(($LSELoadPercentageC1PremiumLSE_LD_SPEC / $LSELoadPercentageC1PremiumLSE_LDST_SPEC), 1), 0)" name="LSE Load Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Store Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE store instructions speculatively executed to the total LSE instructions" expression="if(($LSEStorePercentageC1PremiumLSE_LDST_SPEC &gt; 0), min(($LSEStorePercentageC1PremiumLSE_ST_SPEC / $LSEStorePercentageC1PremiumLSE_LDST_SPEC), 1), 0)" name="LSE Store Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Load/Store Address Execution Unit Utilization">
        <series color="19,148,180" description="This metric measures the average number of load/store operations executed per cycle" expression="if(($LoadStoreAddressExecutionUnitUtilizationC1PremiumCPU_CYCLES &gt; 0), ($LoadStoreAddressExecutionUnitUtilizationC1PremiumIMP_OP_LSU_ISSUE / $LoadStoreAddressExecutionUnitUtilizationC1PremiumCPU_CYCLES), 0)" name="Load/Store Address Execution Unit Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Commit Queue Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where no commit queue resource was available" expression="if(($CommitQueueStallPercentageC1PremiumSTALL_BACKEND_CPUBOUND &gt; 0), min(($CommitQueueStallPercentageC1PremiumIMP_STALL_BACKEND_MCQ / $CommitQueueStallPercentageC1PremiumSTALL_BACKEND_CPUBOUND), 1), 0)" name="Commit Queue Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Non-SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by an instruction that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($NonSVEFloatingPointOperationsPerCycleC1PremiumCPU_CYCLES &gt; 0), ($NonSVEFloatingPointOperationsPerCycleC1PremiumFP_FIXED_OPS_SPEC / $NonSVEFloatingPointOperationsPerCycleC1PremiumCPU_CYCLES), 0)" name="Non-SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageC1PremiumINST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageC1PremiumRC_LD_SPEC / $LoadAcquireInstructionsPercentageC1PremiumINST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageC1PremiumINST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageC1PremiumRC_ST_SPEC / $StoreReleaseInstructionsPercentageC1PremiumINST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Flag Register Rename Percentage">
        <series color="19,148,180" description="This metric measures the percentage of rename stall cycles due to flag register rename availability" expression="if((((($FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF) &gt; 0), min(($FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF / ((($FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $FlagRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF)), 1), 0)" name="Flag Register Rename Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Register Rename Percentage">
        <series color="19,148,180" description="This metric measures the percentage of rename stall cycles due to GPR register rename availability" expression="if((((($IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF) &gt; 0), min(($IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF / ((($IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $IntegerRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF)), 1), 0)" name="Integer Register Rename Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Predicate Register Rename Percentage">
        <series color="19,148,180" description="This metric measures the percentage of rename stall cycles due to predicate register rename availability" expression="if((((($PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF) &gt; 0), min(($PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF / ((($PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $PredicateRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF)), 1), 0)" name="Predicate Register Rename Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Vector Register Rename Percentage">
        <series color="19,148,180" description="This metric measures the percentage of rename stall cycles due to vector register rename availability" expression="if((((($VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF) &gt; 0), min(($VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF / ((($VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_VRF + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_FRF) + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_GRF) + $VectorRegisterRenamePercentageC1PremiumIMP_STALL_BACKEND_RENAME_PDRF)), 1), 0)" name="Vector Register Rename Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageC1PremiumOP_SPEC &gt; 0), min(($RetiredOperationsPercentageC1PremiumOP_RETIRED / $RetiredOperationsPercentageC1PremiumOP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringC1PremiumCPU_CYCLES &gt; 0) &amp;&amp; ($RetiringC1PremiumOP_SPEC &gt; 0), min(((1 - ($RetiringC1PremiumSTALL_SLOT / ($RetiringC1PremiumCPU_CYCLES * 10))) * ($RetiringC1PremiumOP_RETIRED / $RetiringC1PremiumOP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageC1PremiumVFP_SPEC / $FloatingPointOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageC1PremiumASE_SPEC / $AdvancedSIMDOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Operations Percentage">
        <series color="19,148,180" description="This metric measures Scalable Matrix extension data processing operations as a percentage of operations speculatively executed" expression="if(($SMEOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($SMEOperationsPercentageC1PremiumSME_INST_SPEC / $SMEOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="SME Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Integer Store Data Execution Unit Utilization">
        <series color="19,148,180" description="This metric measures the average number of integer store data operations executed per cycle" expression="if(($IntegerStoreDataExecutionUnitUtilizationC1PremiumCPU_CYCLES &gt; 0), ($IntegerStoreDataExecutionUnitUtilizationC1PremiumIMP_OP_STD_ISSUE / $IntegerStoreDataExecutionUnitUtilizationC1PremiumCPU_CYCLES), 0)" name="Integer Store Data Execution Unit Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageC1PremiumLDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageC1PremiumST_SPEC / $StoreAsLoadStoreOperationsPercentageC1PremiumLDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($StoreOperationsPercentageC1PremiumST_SPEC / $StoreOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming FP Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming floating point operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingFPOperationsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingFPOperationsPercentageC1PremiumSSVE_FP_SPEC / $StreamingFPOperationsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming FP Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming integer operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingIntegerOperationsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingIntegerOperationsPercentageC1PremiumSSVE_INT_SPEC / $StreamingIntegerOperationsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Load Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming load operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingLoadOperationsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingLoadOperationsPercentageC1PremiumSSVE_LD_SPEC / $StreamingLoadOperationsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming load and store operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingLoadStoreOperationsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingLoadStoreOperationsPercentageC1PremiumSSVE_LDST_SPEC / $StreamingLoadStoreOperationsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming operations as a percentage of operations speculatively executed Streaming operations include Advanced SIMD, Scalable vector or or Scalable Matrix extension data processing when the CPU is in streaming mode" expression="if(($StreamingOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($StreamingOperationsPercentageC1PremiumSSVE_INST_SPEC / $StreamingOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Streaming Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Slow Instructions Percentage">
        <series color="19,148,180" description="This metric measures streaming slow instructions as a percentage of streaming operations speculatively executed" expression="if(($StreamingSlowInstructionsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingSlowInstructionsPercentageC1PremiumSSVE_SLOW_INSTR / $StreamingSlowInstructionsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming Slow Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Store Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming store operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingStoreOperationsPercentageC1PremiumSSVE_INST_SPEC &gt; 0), min(($StreamingStoreOperationsPercentageC1PremiumSSVE_ST_SPEC / $StreamingStoreOperationsPercentageC1PremiumSSVE_INST_SPEC), 1), 0)" name="Streaming Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKIC1PremiumINST_SPEC &gt; 0), (($StoreExclusiveFailuresPKIC1PremiumSTREX_FAIL_SPEC / $StoreExclusiveFailuresPKIC1PremiumINST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageC1PremiumSTREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageC1PremiumSTREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageC1PremiumSTREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageC1PremiumINST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageC1PremiumSTREX_SPEC / $StoreExclusiveInstructionsPercentageC1PremiumINST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations (Load/Store Inclusive) Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageC1PremiumINST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageC1PremiumSVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageC1PremiumINST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by SVE instructions. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($SVEFloatingPointOperationsPerCycleC1PremiumCPU_CYCLES &gt; 0), ($SVEFloatingPointOperationsPerCycleC1PremiumFP_SCALE_OPS_SPEC / $SVEFloatingPointOperationsPerCycleC1PremiumCPU_CYCLES), 0)" name="SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations as a percentage of operations speculatively executed" expression="if(($SVEOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($SVEOperationsPercentageC1PremiumSVE_SPEC / $SVEOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="SVE Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Empty Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with no active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEEmptyPredicatePercentageC1PremiumSVE_PRED_SPEC &gt; 0), min(($SVEEmptyPredicatePercentageC1PremiumSVE_PRED_EMPTY_SPEC / $SVEEmptyPredicatePercentageC1PremiumSVE_PRED_SPEC), 1), 0)" name="SVE Empty Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Full Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with all active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEFullPredicatePercentageC1PremiumSVE_PRED_SPEC &gt; 0), min(($SVEFullPredicatePercentageC1PremiumSVE_PRED_FULL_SPEC / $SVEFullPredicatePercentageC1PremiumSVE_PRED_SPEC), 1), 0)" name="SVE Full Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Partial Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with at least one active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEPartialPredicatePercentageC1PremiumSVE_PRED_SPEC &gt; 0), min(($SVEPartialPredicatePercentageC1PremiumSVE_PRED_PARTIAL_SPEC / $SVEPartialPredicatePercentageC1PremiumSVE_PRED_SPEC), 1), 0)" name="SVE Partial Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with predicates as a percentage of operations speculatively executed" expression="if(($SVEPredicatePercentageC1PremiumINST_SPEC &gt; 0), min(($SVEPredicatePercentageC1PremiumSVE_PRED_SPEC / $SVEPredicatePercentageC1PremiumINST_SPEC), 1), 0)" name="SVE Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="System DRAM Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of DRAM hits to the total memory accesses that missed in the private L2 cache of the core. This metric indicates that the workload is memory bound obtaining data from the local DRAM." expression="if((($SystemDRAMHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemDRAMHitPercentageC1PremiumL2I_CACHE_REFILL) &gt; 0), min(($SystemDRAMHitPercentageC1PremiumIMP_DRAM_ACCESS / ($SystemDRAMHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemDRAMHitPercentageC1PremiumL2I_CACHE_REFILL)), 1), 0)" name="System DRAM Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="System L3 Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of system L3 cache hits to the total memory accesses that missed in the private L2 cache of the core. This metric indicates that the workload is memory bound obtaining data from L3 cache." expression="if((($SystemL3CacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemL3CacheHitPercentageC1PremiumL2I_CACHE_REFILL) &gt; 0), min(($SystemL3CacheHitPercentageC1PremiumL3D_CACHE_HIT / ($SystemL3CacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemL3CacheHitPercentageC1PremiumL2I_CACHE_REFILL)), 1), 0)" name="System L3 Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="System Last Level Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of system last level cache hits to the total memory accesses that missed in the private L2 cache of the core. This metric indicates that the workload is memory bound obtaining data from system's last level cache." expression="if((($SystemLastLevelCacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemLastLevelCacheHitPercentageC1PremiumL2I_CACHE_REFILL) &gt; 0), min(($SystemLastLevelCacheHitPercentageC1PremiumLL_CACHE_HIT / ($SystemLastLevelCacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemLastLevelCacheHitPercentageC1PremiumL2I_CACHE_REFILL)), 1), 0)" name="System Last Level Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="System Peer Cluster Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of peer cluster cache hits to the total memory accesses that missed in the private L2 cache of the core This metric indicates that the workload is memory bound obtaining data from peer cores in the compute cluster" expression="if((($SystemPeerClusterCacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemPeerClusterCacheHitPercentageC1PremiumL2I_CACHE_REFILL) &gt; 0), min((($SystemPeerClusterCacheHitPercentageC1PremiumDSNP_HIT + $SystemPeerClusterCacheHitPercentageC1PremiumISNP_HIT_RD) / ($SystemPeerClusterCacheHitPercentageC1PremiumL2D_CACHE_REFILL + $SystemPeerClusterCacheHitPercentageC1PremiumL2I_CACHE_REFILL)), 1), 0)" name="System Peer Cluster Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Vector Execution Unit Utilization">
        <series color="19,148,180" description="This metric measures the average number of vector operations executed per cycle" expression="if(($VectorExecutionUnitUtilizationC1PremiumCPU_CYCLES &gt; 0), ($VectorExecutionUnitUtilizationC1PremiumIMP_OP_VPU_ISSUE / $VectorExecutionUnitUtilizationC1PremiumCPU_CYCLES), 0)" name="Vector Execution Unit Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ZA Active Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles when PSTATE. ZA was enabled to the total number of CPU cycles." expression="if(($ZAActiveCyclesPercentageC1PremiumCPU_CYCLES &gt; 0), min(($ZAActiveCyclesPercentageC1PremiumZA_ACTIVE_CYCLES / $ZAActiveCyclesPercentageC1PremiumCPU_CYCLES), 1), 0)" name="ZA Active Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Add Sub Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point addition or subtraction operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAAddSubFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC &gt; 0), min(($StreamingZAAddSubFloatingPointOperationsPercentageC1PremiumSME_FP_ADDSUB_SPEC / $StreamingZAAddSubFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC), 1), 0)" name="Streaming ZA Add Sub Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Dot Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point dot product operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZADotFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC &gt; 0), min(($StreamingZADotFloatingPointOperationsPercentageC1PremiumSME_FP_DOT_SPEC / $StreamingZADotFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC), 1), 0)" name="Streaming ZA Dot Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA FMA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point multiply-add, multiply-add long, multiply-subtract and multiply-subtract long operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAFMAFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC &gt; 0), min(($StreamingZAFMAFloatingPointOperationsPercentageC1PremiumSME_FP_FMA_SPEC / $StreamingZAFMAFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC), 1), 0)" name="Streaming ZA FMA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA MOPA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point outer product and accumulate, or outer product and subtract operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAMOPAFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC &gt; 0), min(($StreamingZAMOPAFloatingPointOperationsPercentageC1PremiumSME_FP_MOPA_SPEC / $StreamingZAMOPAFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC), 1), 0)" name="Streaming ZA MOPA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point operations and used ZA arrays as a percentage of all the SME operations speculatively executed that used ZA array ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAFloatingPointOperationsPercentageC1PremiumSME_INST_SPEC &gt; 0), min(($StreamingZAFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC / $StreamingZAFloatingPointOperationsPercentageC1PremiumSME_INST_SPEC), 1), 0)" name="Streaming ZA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Other Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point operations that used ZA arrays not counted in any other category as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAOtherFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC &gt; 0), min(($StreamingZAOtherFloatingPointOperationsPercentageC1PremiumSME_FP_OTHER_SPEC / $StreamingZAOtherFloatingPointOperationsPercentageC1PremiumSME_FP_SPEC), 1), 0)" name="Streaming ZA Other Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Dot Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer dot product operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZADotIntegerOperationsPercentageC1PremiumSME_INT_SPEC &gt; 0), min(($StreamingZADotIntegerOperationsPercentageC1PremiumSME_INT_DOT_SPEC / $StreamingZADotIntegerOperationsPercentageC1PremiumSME_INT_SPEC), 1), 0)" name="Streaming ZA Dot Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA MOPA Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer outer product and accumulate, or outer product and subtract operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAMOPAIntegerOperationsPercentageC1PremiumSME_INT_SPEC &gt; 0), min(($StreamingZAMOPAIntegerOperationsPercentageC1PremiumSME_INT_MOPA_SPEC / $StreamingZAMOPAIntegerOperationsPercentageC1PremiumSME_INT_SPEC), 1), 0)" name="Streaming ZA MOPA Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer operations that used ZA arrays as a percentage of all the SME operations speculatively executed that used ZA array ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAIntegerOperationsPercentageC1PremiumSME_INST_SPEC &gt; 0), min(($StreamingZAIntegerOperationsPercentageC1PremiumSME_INT_SPEC / $StreamingZAIntegerOperationsPercentageC1PremiumSME_INST_SPEC), 1), 0)" name="Streaming ZA Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Other Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer operations that used ZA arrays not counted in any other category as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAOtherIntegerOperationsPercentageC1PremiumSME_INT_SPEC &gt; 0), min(($StreamingZAOtherIntegerOperationsPercentageC1PremiumSME_INT_OTHER_SPEC / $StreamingZAOtherIntegerOperationsPercentageC1PremiumSME_INT_SPEC), 1), 0)" name="Streaming ZA Other Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Operations Percentage">
        <series color="19,148,180" description="This metric measures SME operations that used ZA arrays as a percentage of operations speculatively executed ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAOperationsPercentageC1PremiumINST_SPEC &gt; 0), min(($StreamingZAOperationsPercentageC1PremiumSME_INST_SPEC / $StreamingZAOperationsPercentageC1PremiumINST_SPEC), 1), 0)" name="Streaming ZA Operations Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv9_C1_Premium_metric_backend_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_busy_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cme_backpressure_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cme_busy_arb_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cme_busy_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_cme_cpu_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_core_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_core_cme_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_core_other_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_core_spec_throttle_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cme_barrier_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cme_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cme_hazard_cpu_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cme_lsrt_full_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_cpu_hazard_cme_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_C1_Premium_metric_bad_speculation" />
    <select-metric id="ARMv9_C1_Premium_metric_barrier_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_branch_return_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_bus_access_average_count" />
    <select-metric id="ARMv9_C1_Premium_metric_bus_read_requests_average_latency" />
    <select-metric id="ARMv9_C1_Premium_metric_cas_far_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cas_near_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_alloc_cycles_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_alu_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_arb_pending_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_core_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_mem_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_mem_store_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_backend_prefetch_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_bus_access_average_length" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_frontend_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_frontend_cpu_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_frontend_other_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_ipc" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_iq_dp0_stall_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_iq_dp1_stall_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_iq_load_stall_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1_prefetcher_accuracy" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1_prefetcher_coverage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1_prefetcher_timeliness" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l1d_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l3d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l3d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_l3d_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_ll_cache_read_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_load_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_mac_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_mmdp_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_mmmv_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_perm_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_retiring" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_st_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_store_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_system_dram_mem_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_system_l3d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cme_system_ll_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_cpi" />
    <select-metric id="ARMv9_C1_Premium_metric_crypto_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_block_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_page_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_fp16_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_fp32_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_fp64_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_fp_ops_per_cycle" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_flush_machine_clear_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_flush_resteer_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_core_spec_throttle_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_C1_Premium_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_C1_Premium_metric_instruction_fetch_average_latency" />
    <select-metric id="ARMv9_C1_Premium_metric_int_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_ipc" />
    <select-metric id="ARMv9_C1_Premium_metric_iq_stall_lsu_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_iq_stall_mx_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_iq_stall_sx_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_iq_stall_vpu_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_block_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_page_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l1_prefetcher_accuracy" />
    <select-metric id="ARMv9_C1_Premium_metric_l1_prefetcher_coverage" />
    <select-metric id="ARMv9_C1_Premium_metric_l1_prefetcher_timeliness" />
    <select-metric id="ARMv9_C1_Premium_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_accuracy_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_accuracy_l1hwprf_inclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_coverage_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_coverage_l1hwprf_inclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_timeliness_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_prefetcher_timeliness_l1hwprf_inclusive" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l2d_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l2i_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l2i_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_ldrex_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_load_average_latency" />
    <select-metric id="ARMv9_C1_Premium_metric_load_ls_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_load_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_load_store_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_lse_atomics_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_lse_load_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_lse_store_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_lsu_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_mcq_stall_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_nonsve_fp_ops_per_cycle" />
    <select-metric id="ARMv9_C1_Premium_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_rc_st_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_rename_stall_flags_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_rename_stall_int_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_rename_stall_pred_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_rename_stall_vec_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_retired_ops_percent" />
    <select-metric id="ARMv9_C1_Premium_metric_retiring" />
    <select-metric id="ARMv9_C1_Premium_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_simd_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sme_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_std_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_store_ls_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_store_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_fp_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_int_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_ld_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_ls_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_slow_inst_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_streaming_st_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_strex_fail_mpki" />
    <select-metric id="ARMv9_C1_Premium_metric_strex_fail_percent" />
    <select-metric id="ARMv9_C1_Premium_metric_strex_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_all_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_fp_ops_per_cycle" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_predicate_empty_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_predicate_full_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_predicate_partial_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_sve_predicate_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_system_dram_mem_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_system_l3_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_system_llc_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_system_peer_cluster_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_vpu_port_utilization" />
    <select-metric id="ARMv9_C1_Premium_metric_za_active_cycles_ratio" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_addsub_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_dot_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_fma_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_mopa_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_fp_other_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_int_dot_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_int_mopa_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_int_op_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_int_other_percentage" />
    <select-metric id="ARMv9_C1_Premium_metric_za_op_percentage" />
</template>
